<?php
class Settings extends MY_Controller
{
     public $module_name;
    function __construct()
    {

        parent::__construct();
        $this->module_name = $this->router->fetch_module();
        
        $this->load->model('../extensions/'.$this->module_name.'/models/Bookings_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/User_model');
        
        $view_data['menu_on'] = true;   
        $this->load->vars($view_data);
    }   

    function show_booking_list()
    {
        $user_id = $this->session->userdata('user_id');
        $data['is_reminder_hidden'] = $this->User_model->is_reminder_hidden($user_id);

        $data['selling_date'] = $this->selling_date;

        $filters = array(
            'filter_booking_list' => array(
                'start_date' => $this->selling_date,
                'end_date' => $this->selling_date,
                'date_overlap' => $this->selling_date
            ),
            'not_include_charge_payment_total' => true,
            'fetch_checkindate_with_room_name' => true
        );

        $bookings = $this->Bookings_model->get_bookings($filters, null, null, true);

        $this->load->model('../extensions/guest-signature-integration/models/Guest_signature_model');

        foreach($bookings as $key => $booking)
        {
            $booking['current_room_name'] = $booking['room_name'];
            if (isset($booking['room_name']) && $booking['room_name']) {
                $room_name = $booking['room_name'];
                $room_names = explode(",", $room_name);
                $rooms_ar = array();
                foreach($room_names as $room_name) {
                    $room_name_ar = explode("|$|", $room_name);
                    $name = $room_name_ar[0];
                    $date = $room_name_ar[1];
                    $rooms_ar[$date] = $name;
                }

                uksort($rooms_ar, function ($dt1, $dt2) {
                    $tm1 = strtotime($dt1);
                    $tm2 = strtotime($dt2);

                    return ($tm1 < $tm2) ? -1 : (($tm1 > $tm2) ? 1 : 0);
                });

                $booking['room_name'] = implode(",", $rooms_ar);
                $booking['current_room_name'] = end($rooms_ar);
            }

            
            // Group booking by state
            switch ($booking['state']) {
                case UNCONFIRMED_RESERVATION:
                    $data['unconfirmed_reservations'][] = $booking;
                    break;

                case INHOUSE:
                    $data['staying_and_paying'][] = $booking;
                    break;

                case RESERVATION:
                    $data['checking_in_today'][] = $booking;
                    break;

                case CHECKOUT:
                    $data['checked_out_today'][] = $booking;
                    break;

                case OUT_OF_ORDER:
                    $data['out_of_order_bookings'][] = $booking;
                    break;
            }

            // Assign guest signature (common for all states)
            $signature = $this->Guest_signature_model->get_signature_detail($booking['booking_id']);
            if ($signature && !empty($signature->guest_signature)) {
                $signature_path = base_url() . 'application/extensions/guest-signature-integration/signatures/booking_' . $booking['booking_id'] . '/' . $signature->guest_signature;
                $data['guest_signature'][$booking['current_room_name']][$booking['booking_id']] = $signature_path;
            }
        }

        if (isset($data['out_of_order_bookings']) && count($data['out_of_order_bookings']) > 0) {
            usort($data['out_of_order_bookings'], function($a, $b){ return strcmp($a["current_room_name"], $b["current_room_name"]); });
        }
        if (isset($data['checking_in_today']) && count($data['checking_in_today']) > 0) {
            usort($data['checking_in_today'], function($a, $b){ return strcmp($a["current_room_name"], $b["current_room_name"]); });
        }
        if (isset($data['checked_out_today']) && count($data['checked_out_today']) > 0) {
            usort($data['checked_out_today'], function($a, $b){ return strcmp($a["current_room_name"], $b["current_room_name"]); });
        }
        if (isset($data['staying_and_paying']) && count($data['staying_and_paying']) > 0) {
            usort($data['staying_and_paying'], function($a, $b){ return strcmp($a["current_room_name"], $b["current_room_name"]); });
        }
        if (isset($data['unconfirmed_reservations']) && count($data['unconfirmed_reservations']) > 0) {
            usort($data['unconfirmed_reservations'], function($a, $b){ return strcmp($a["current_room_name"], $b["current_room_name"]); });
        }

        //Note: This is not using template loader. Javascript and css files are loaded in view
      
        $this->load->view('../extensions/'.$this->module_name.'/views/booking_list', $data);
    }

    function download_csv_export($booking_type) {
        $booking_types = Array($booking_type);

        //get user's shift information
        $query = $this->Bookings_model->get_csv_data($this->company_id, $booking_types, $this->selling_date, $this->selling_date);

        $this->load->dbutil();
        $csv = $this->dbutil->csv_from_result($query);
        $this->load->helper('download');
        force_download("bookings-" . $this->selling_date . ".csv", $csv);
    }

    function download_csv_export_rate_plan($rate_plan_id) {
        // Execute the query to fetch the data
        $result = $this->Bookings_model->get_csv_rate_plan_data($this->company_id, $rate_plan_id, $this->selling_date, $this->selling_date);

        // Check if the query result is valid
        if ($result['result'] !== false) {

            $this->load->helper('download');

            $csv_keys = array(
                "booking_id" => "Booking Id",
                "check_in_date" => "Check-in date",
                "check_out_date" => "Check-Out date",
                "adult_count" => "Number of Adults",
                "rate_plan_name" => "Rate Plan Name",
            );

            $bookings = array($csv_keys);

            $booking_row = array();
            $total_adults = 0;

            foreach ($result['result'] as $key => $value) {
                $booking_row = array();
                $booking_row[] = $value['booking_id'];
                $booking_row[] = $value['check_in_date'];
                $booking_row[] = $value['check_out_date'];
                $booking_row[] = $value['adult_count'];

                if($rate_plan_id == 'select_all'){
                    $rp_name = explode(' #', $value['rate_plan_name']);

                    $booking_row[] = $rp_name[0];
                } else {
                    $booking_row[] = $result['rate_plan_name'];
                }

                $total_adults += $value['adult_count']; // Summing up the total adults
                
                $bookings[] = $booking_row;
            }

            // Add a final row for the total number of adults
            $bookings[] = array("Total", "", "", $total_adults, "");

            $csv_name = $result['rate_plan_name'] .' - '. $result['adult_count'] .' guest';
            force_download_csv($bookings, $csv_name . ".csv");

        } else {
            // Handle the error, maybe redirect with an error message or show a notification
            show_error('Unable to generate the CSV. Please try again later.');
        }
    }

    function set_reminder_as_hidden()
    {
        $this->User_model->set_reminder_as_hidden($this->user_id);
        echo json_encode("");
    }

    function set_reminder_as_visible()
    {
        $this->User_model->set_reminder_as_visible($this->user_id);
        echo json_encode("");
    }

}
